
var globalData = require('../global/globalData');
const date = require('date-and-time');
var Database = require('../database/clsQueryProcess');
const { models } = require('../../config/dbConnection');
const sequelize = require('../../config/dbConnection').sequelize;
var database = new Database();
/**
 *@description Class holding methods of instrument usage Log 
 */
class InstrumentUsageLog {
    /**
     * 
     * @param {*} instrumentID ID of instrument
     * @param {*} ProbType ID of ProbType
     * @param {*} ProbID ID of ProbID
     * @param {*} IdsNo Ids number
     * @param {*} tableName TableName for instrumwnt usage
     * @param {*} activity Weighment type
     * @param {*} options Whether started or completed so 1:Started and 0:Completeed
     */
    async InstrumentUsage(instrumentID, ProbType,  IdsNo, activity, options) {
        //var tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == IdsNo);
        let tableName = "tbl_instrumentlog";
        const tempUserObject = globalData.arrUsers.find(k => k.Hmi == IdsNo);
        //var instrumentId;

        if (options == '1') {
            var now = new Date();
            var activityObject = await models[tableName].create({
                MeterID: instrumentID,
                ProbType: ProbType,
                // ProbID: ProbID,
                FromDT: date.format(now, 'YYYY-MM-DD'),
                FromTM: date.format(now, 'HH:mm:ss'),
                Activity: activity,
                UserId: tempUserObject.UserId,
                UserName: tempUserObject.UserName,

            })
        } else {
            var now = new Date();
            // Selecting Max Record number
            let selectDataToUpdate = await models[tableName].findAll({
                attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
                where: {
                    MeterID: instrumentID,
                    ProbType: ProbType,
                    // ProbID: ProbID
                }
            });
            // var selectDataToUpdate = {
            //     str_tableName: tableName,
            //     data: 'MAX(RecNo) as RecNo',
            //     condition: [
            //         { str_colName: 'MeterID', value: instrumentID },
            //         { str_colName: 'ProbType', value: ProbType },
            //         { str_colName: 'ProbID', value: ProbID }
            //     ]
            // }
            var res = selectDataToUpdate;
            var RecNo = res[0].RecNo;
            var updateactivityObject = await models[tableName].update({
                ToDT: date.format(now, 'YYYY-MM-DD'),
                ToTM: date.format(now, 'HH:mm:ss')
            }, {
                where: {
                    RecNo: RecNo
                }
            }
            );

        }
    }
}
module.exports = InstrumentUsageLog;