const requestIP = require('request-ip');
const joi = require('joi');


//modules
const LoginSchema = require('../validations/login.schema');
const LoginModel = require('../model/Login/login.model');
const globaldata = require('../global/globalData');

//instances of respective classes
const objLoginModal = new LoginModel();
exports.getIDSNo = (req, res) => {
    let responseObj = {}
    objLoginModal.getIDSNo(req)
        .then((result) => {
            if (result.status === 'success') {
                res.statusCode = 200;
                res.json(result)
            } else {
                res.statusCode = 200;
                res.json(result)
            }
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
            res.send(responseObj);
        })
}
exports.loginApi = (req, res) => {
    // const { error, value } = LoginSchema.ValidateloginApi().validate(req.body);
    var Ip = requestIP.getClientIp(req);
    objLoginModal.loginApi(req.body)
        .then(result => {
            if (result.status === 'success') {
                res.statusCode = 200;
                res.json(result)
            }
            else {
                res.statusCode = 200;
                res.json(result)
            }

        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            res.send(responseObj);
        });
}

// exports.loginApi = (req, res) => {
//     var Ip = requestIP.getClientIp(req);
//     joi.validate(req.body, LoginSchema.ValidateloginApi(), function (err, value) {
//         if (err) {
//             res.statusCode = 400;
//             let responseObj = {}
//             Object.assign(responseObj, {
//                 status: 'fail',
//                 message: err.details[0].message.replace(/"/g, "")
//             })
//             res.send(responseObj);
//         } else {

//             objLoginModal.loginApi(value)
//                 .then((result) => {

//                     if (result.status === 'success') {
//                         res.statusCode = 200;
//                         res.json(result)
//                     } else {
//                         res.statusCode = 200;
//                         res.json(result)
//                     }
//                 }).catch((err) => {
//                     console.log(err)
//                     res.statusCode = 500;
//                     let responseObj = {}
//                     Object.assign(responseObj, {
//                         status: 'fail',
//                         message: 'Internal server error'
//                     })
//                     res.send(responseObj);
//                 });
//         }
//     })
// }

exports.logout = (req, res) => {
    const { error, value } = LoginSchema.ValidateUserLogout().validate(req.body);
    let responseObj = {}

    if (error) {

        res.statusCode = 400;
        Object.assign(responseObj, { status: 'Bad Request' }, { message: error.details[0].message })
        res.send(responseObj);
    }
    else {
        objLoginModal.logout(req.body)
            .then(result => {
                res.statusCode = 200
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                Object.assign(responseObj, { status: 'fail' }, { message: 'Internal Server Error' })
                res.send(responseObj);

            })
    }
}

exports.passwordHistory = (req, res) => {
    if ((req.body.userId === "") || (req.body.userId === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        objLoginModal.passwordHistory(req).then(result => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.updatepassword = (req, res) => {
    if ((req.body.userId === "") || (req.body.userId === undefined) ||
        (req.body.userPassword === "") || (req.body.userPassword === undefined) ||
        (req.body.userOldPassword === undefined) || (req.body.userOldPassword === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        objLoginModal.updatepassword(req).then(result => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}