const momentObj = require('moment');
const Joi = require('joi');
const clsWeighmentSchema = require('../validations/weighment.schema');
const clsWeighment = require('../model/Weighment/clsProduct.test');
const e = require('cors');
const objWeighment = new clsWeighment();
exports.getWeighment = (req, res) => {
    Joi.validate(req.body, clsWeighmentSchema.ValidateGetProductTypeSchema(), (err, value) => {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: err.details[0].message.replace(/"/g, "")
            })
            res.send(responseObj);
        } else {
            objWeighment.Product_Type(req.body).then((result) => {
                res.statusCode = 200;
                res.send(result);
               
            }).catch((err) => {
                console.log(err);
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })

}


exports.getproduct = (req, res) => {
   
    Joi.validate(req.body, clsWeighmentSchema.ValidateGetProducSchema(), (err, value) => {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: err.details[0].message.replace(/"/g, "")
            })
            res.send(responseObj);
        } else {
            objWeighment.Product(req.body).then((result) => {
                res.statusCode = 200;
                res.send(result);
               
            }).catch((err) => {
                console.log(err);
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })

}


exports.getARSampleNo = (req, res) => {
   
    Joi.validate(req.body, clsWeighmentSchema.ValidateGetARSampleTypeSchema(), (err, value) => {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: err.details[0].message.replace(/"/g, "")
            })
            res.send(responseObj);
        } else {
            objWeighment.ARNo(req.body).then((result) => {
                res.statusCode = 200;
                res.send(result);
               
            }).catch((err) => {
                console.log(err);
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })

}