const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog')
const dbCon = require('../../global/dbCon');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const objActivityLog = new clsActivityLog();
const objclsInstrumentUsageLog = new clsInstrumentUsage();
const date = require('date-and-time');
const clsPrint = require('../Weighment/clsonlineprint');
const objPrint = new clsPrint();

const momentObj = require('moment');
const { models } = require('../../../config/dbConnection');

class WeighmentSave {

    async saveDOWdata(Data) {
        try {
            var strDP = ''
            var ChannelNo = Data.Parsedata.Channel;
            var strHmi = Data.strHmi;
            var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.idsNo == strHmi)
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode
            var objProduct = globalData.arrMaterialProductSelected.find(k => k.idsNo == strHmi);
            var strUnit = tempCubicInfo[`Sys_Port${ChannelNo}_unit`]
            var strProbeType = tempCubicInfo[`Sys_Port${ChannelNo}_Type`]
            var strProbeID = tempCubicInfo[`Sys_Port${ChannelNo}_ID`]
            globalData.arrDOWData.rdoindoflag = false
            var ObjMaterail = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);

            var ARnumber = ObjMaterail.selectedProductDetail.AR_No;
            if (ARnumber == null || ARnumber == "") {
                ARnumber = 'NA';
            }
            var BatchNumer = ObjMaterail.selectedProductDetail.Batch_No;
            if (BatchNumer == null || BatchNumer == "") {
                BatchNumer = 'NA';
            }
            var Product_Type = ObjMaterail.selectedProductDetail.Product_Type;
            let now = new Date();
            var objActivity = {};
            var objUserInfo = globalData.arrUsers.find(k => k.IdsNo == ObjMaterail.idsNo);
            Object.assign(objActivity,
                { strUserId: objUserInfo.UserId },
                { strUserName: objUserInfo.UserName },
                { activity: 'Weighment started by user on IDS ' + ObjMaterail.idsNo })
            await objActivityLog.ActivityLogEntry(objActivity)

            var phReading = Data.Parsedata;
            if (phReading.Saturation.split(' ')[0].includes('.')) {
                var strArrPhVal = phReading.Saturation.split(' ')[0].trim().split('.')
                strDP = strArrPhVal[1].length
            }
            else {
                strDP = 0
            }
            var selectrange = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ProbID: strProbeID,
                }
            })
            let objselectrange = [selectrange]
            let strPosTol = objselectrange[0][0].meterwt_PosTol
            let strNegTol = objselectrange[0][0].meterwt_NegTol

            if (phReading.PartialPressure != 0 && phReading.PartialPressure != undefined) {

                var insertData = await models.tbl_weighment_master_rdo.create({
                    'dt': date.format(now, 'YYYY-MM-DD'),
                    'tm': date.format(now, 'HH:mm:ss'),
                    'ProductName': ObjMaterail.ProductSelected,
                    'SampleID': BatchNumer,
                    'ArNo': ARnumber,
                    'ProductType': ObjMaterail.Productype,
                    'MeterID': ObjIDS.BalID,
                    'ProbID': strProbeID,
                    'ChannelNo': ChannelNo,
                    'PrinterName': tempCubicInfo.Sys_Printer,
                    'UserID': ObjUser.UserId,
                    'UserName': ObjUser.UserName,
                    'DP': strDP,
                    'PrintNo': 0,
                    'IDSNo': ObjMaterail.idsNo,
                    'Slope': phReading.Slope,
                    'Saturation': phReading.Saturation,
                    'Concentration': phReading.Concentration,
                    'PartialPressure': phReading.PartialPressure,
                    'Current': phReading.Current,
                    'TempSolution': phReading.TempSolution,
                    'TempMembrane': phReading.TempMembrane,
                    'BioPressure': phReading.BioPressure,
                    'SalinityCorrection': phReading.SalinityCorrection,
                    'ProdID': objProduct.ProuductID
                })
                globalData.arrDOWData.rdoindoflag = true
            }

            else {

                var insertData = await models.tbl_weighment_master_do.create({

                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    ProductName: ObjMaterail.selectedProductDetail.Product_Name,
                    SampleID: BatchNumer,
                    ArNo: ARnumber,
                    NegTol: strNegTol,
                    PosTol: strPosTol,
                    ProductType: Product_Type,
                    MeterID: objselectrange[0][0].meterwt_ID,
                    ProbID: strProbeID,
                    ChannelNo: ChannelNo,
                    PrinterName: tempCubicInfo.Sys_Printer,
                    UserID: objUserInfo.UserId,
                    UserName: objUserInfo.UserName,
                    DP: strDP,
                    PrintNo: 0,
                    IDSNo: ObjMaterail.Hmi,
                    Slope: phReading.Slope,
                    Saturation: phReading.Saturation,
                    Concentration: phReading.Concentration,
                    Current: phReading.Current,
                    TempSolution: phReading.Solution_Temp,
                    TempMembrane: phReading.Membrane_Temp,
                    BioPressure: phReading.Barometric_Pressure,
                    SalinityCorrection: phReading.Salinity_Correction,
                    ProdID: objProduct.ProuductID

                })
            }
            var lastInsertedID = insertData.RecNo;
            if (objLastInsertedRepserNo == undefined) {
                globalData.LastInsertedRepserNo.push({
                    IdsNo: strHmi,
                    LastInsertedRepserNo: lastInsertedID
                })

            }
            else {
                objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
            }


            Object.assign(objActivity,
                { strUserId: objUserInfo.UserId },
                { strUserName: objUserInfo.UserName },
                { activity: 'Weighment completed by user on TSH ' + ObjMaterail.idsNo })
            await objActivityLog.ActivityLogEntry(objActivity)
            var obj = await objclsInstrumentUsageLog.InstrumentUsage(strProbeID, Product_Type, strHmi, 'DO Weighment', 0)
            console.log(" Report Generated");
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);

            //online printing
            if (strPrintingMode == 'Auto') {
                var Print_Protocol = await objPrint.AutoPrint(strHmi, "Test");

                if (Print_Protocol == undefined) {
                    Print_Protocol = 'Report Generated';
                    console.log('ProcessPhMeter where print mode is auto')
                }
                return Print_Protocol;
            }
            else {
                return Print_Protocol;
            }


        } catch (err) {
            console.log(err);
            var objDOWData = globalData.arrDOWData.find(k => k.idsNo == parseInt(IdsNo));
            if (objDOWData == undefined) {
                globalData.arrDOWData.push({
                    idsNo: IdsNo, Slope: 0, Saturation: 0,
                    Concentration: 0, Current: 0, TempSolution: 0, TempMembrane: 0,
                    BioPressure: 0, SalinityCorrection: 0, PartialPressure: 0,
                });
            } else {
                objDOWData.Saturation = 0;
                objDOWData.Concentration = 0;
                objDOWData.Current = 0;
                objDOWData.TempSolution = 0;
                objDOWData.TempMembrane = 0;
                objDOWData.BioPressure = 0;
                objDOWData.SalinityCorrection = 0;
                objDOWData.PartialPressure = 0;
            }
            var logQ = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " ," + err;
            clsErrorLog.addToErrorLog(logQ);
            throw new Error(err)
        }
    }
    async savePHdata(Data) {
        try {

            var strDP = ''
            var ChannelNo = Data.Parsedata.Channel;
            var strHmi = Data.strHmi;
            var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.IdsNo == strHmi)
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode
            var objProduct = globalData.arrMaterialProductSelected.find(k => k.idsNo == strHmi);
            var strUnit = tempCubicInfo[`Sys_Port${ChannelNo}_unit`]
            var strProbeType = tempCubicInfo[`Sys_Port${ChannelNo}_Type`]
            var strProbeID = tempCubicInfo[`Sys_Port${ChannelNo}_ID`]
            var ObjMaterail = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);

            var ARnumber = ObjMaterail.selectedProductDetail.AR_No;
            if (ARnumber == null || ARnumber == "") {
                ARnumber = 'NA';
            }
            var BatchNumer = ObjMaterail.selectedProductDetail.Batch_No;
            if (BatchNumer == null || BatchNumer == "") {
                BatchNumer = 'NA';
            }

            let now = new Date();
            var objActivity = {};
            var objUserInfo = globalData.arrUsers.find(k => k.Hmi == strHmi);
            Object.assign(objActivity,
                { strUserId: objUserInfo.UserId },
                { strUserName: objUserInfo.UserName },
                { activity: 'Weighment started by user on TSH ' + strHmi })
            await objActivityLog.ActivityLogEntry(objActivity)

            var phReading = Data.Parsedata;

            if (phReading.pH.includes('.')) {
                var strArrPhVal = phReading.pH.trim().split('.')
                strArrPhVal = phReading.pH.trim().split('.')[1].split(' ')
                strDP = strArrPhVal[0].length
            }
            else {
                strDP = 0
            }

            var objselectrange = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ProbID: strProbeID
                }
            })
            var strPosTol = objselectrange[0].meterwt_PosTol
            var strNegTol = objselectrange[0].meterwt_NegTol

            const insertData = await models.tbl_weighment_master_ph.create({
                ProductName: ObjMaterail.selectedProductDetail.Product_Name,
                ProductType: ObjMaterail.selectedProductDetail.Product_Type,
                IDSNo: ObjMaterail.selectedProductDetail.Hmi,
                MeterID: objselectrange[0].meterwt_ID,
                NegTol: strNegTol,
                PosTol: strPosTol,
                UserID: objUserInfo.UserId,
                UserName: objUserInfo.UserName,
                dt: momentObj().format('YYYY-MM-DD'),
                tm: momentObj().format('HH:mm:ss'),
                DP: strDP,
                ArNo: ObjMaterail.selectedProductDetail.AR_No,
                SampleID: ObjMaterail.selectedProductDetail.Sample_Id,
                ChannelNo: ChannelNo,
                PrintNo: 0,
                ProbID: strProbeID,
                ProdID: ObjMaterail.selectedProductDetail.Product_ID
            });

            var resultincomplete = insertData.dataValues.RecNo;
            var lastInsertedID = resultincomplete;
            if (lastInsertedID != 0) {
                const DetailEntry = await models.tbl_weighment_detail_ph.create({
                    RepSerNo: lastInsertedID,
                    RecSeqNo: 1,
                    PhValue: phReading.pH,
                    MvValue: phReading.mV,
                    Temp: phReading.Temperature
                })
                // var ResDetailEntry = DetailEntry[0];
                Object.assign(objActivity,
                    { strUserId: objUserInfo.UserId },
                    { strUserName: objUserInfo.UserName },
                    { activity: 'Weighment completed by user on TSH ' + strHmi })
                await objActivityLog.ActivityLogEntry(objActivity)


                if (objLastInsertedRepserNo == undefined) {
                    globalData.LastInsertedRepserNo.push({
                        IdsNo: strHmi,
                        LastInsertedRepserNo: lastInsertedID
                    })

                }
                else {
                    objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
                }
                // console.log(" Report Generated");
                // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);
                //online printing
                if (strPrintingMode == 'Auto') {
                    var Print_Protocol = await objPrint.AutoPrint(strHmi, "Test");

                    if (Print_Protocol == undefined) {
                        Print_Protocol = 'Report Generated';
                        console.log('ProcessPhMeter where print mode is auto')
                    }
                    return Print_Protocol;
                }
                else {
                    return Print_Protocol;
                }

                // return;

            }


        } catch (err) {
            console.log(err);
            throw new Error(err)
        }
    }

    async saveConductivitycalidData(Data) {
        try {
            var strDP = ''
            var ChannelNo = Data.Parsedata.Channel;
            var strHmi = Data.strHmi;
            var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.IdsNo == strHmi)
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode
            var objProduct = globalData.arrMaterialProductSelected.find(k => k.idsNo == strHmi);
            var strUnit = tempCubicInfo[`Sys_Port${ChannelNo}_unit`]
            var strProbeType = tempCubicInfo[`Sys_Port${ChannelNo}_Type`]
            var strProbeID = tempCubicInfo[`Sys_Port${ChannelNo}_ID`]
            var ObjMaterail = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);

            var ARnumber = ObjMaterail.selectedProductDetail.AR_No;
            if (ARnumber == null || ARnumber == "") {
                ARnumber = 'NA';
            }
            var BatchNumer = ObjMaterail.selectedProductDetail.Batch_No;
            if (BatchNumer == null || BatchNumer == "") {
                BatchNumer = 'NA';
            }

            let now = new Date();
            var objActivity = {};
            var objUserInfo = globalData.arrUsers.find(k => k.Hmi == strHmi);
            Object.assign(objActivity,
                { strUserId: objUserInfo.UserId },
                { strUserName: objUserInfo.UserName },
                { activity: 'Weighment started by user on TSH ' + strHmi })
            await objActivityLog.ActivityLogEntry(objActivity)
            var phReading = Data.Parsedata;
            if (phReading.Conductivity.includes('.')) {
                var strArrPhVal = phReading.Conductivity.trim().split('.')
                strArrPhVal = phReading.Conductivity.trim().split('.')[1].split(' ')
                strDP = strArrPhVal[0].length
            }
            else {
                strDP = 0
            }

            var objselectrange = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ProbID: strProbeID
                }
            })
            let strPosTol = objselectrange[0].meterwt_PosTol
            let strNegTol = objselectrange[0].meterwt_NegTol

            const insertData = await models.tbl_weighment_master_conductivity.create({

                dt: momentObj().format('YYYY-MM-DD'),
                tm: momentObj().format('HH:mm:ss'),
                ProductName: ObjMaterail.selectedProductDetail.Product_Name,
                SampleID: BatchNumer,
                ArNo: ARnumber,
                ProductType: ObjMaterail.selectedProductDetail.Product_Type,
                MeterID: objselectrange[0].meterwt_ID,
                ProbID: strProbeID,
                ChannelNo: ChannelNo,
                PrinterName: tempCubicInfo.Sys_Printer,
                UserID: objUserInfo.UserId,
                UserName: objUserInfo.UserName,
                DP: strDP,
                PrintNo: 0,
                ProdID: ObjMaterail.selectedProductDetail.Product_ID,
                IDSNo: strHmi
            })

            var resultincomplete = insertData.dataValues.RecNo;
            var lastInsertedID = resultincomplete;

            //*selecting pos and neg tolerences******************* */

            //**************************************************** */

            if (lastInsertedID != 0) {
                const DetailEntry = await models.tbl_weighment_detail_conductivity.create({
                    RepSerNo: lastInsertedID,
                    RecSeqNo: 1,
                    Conductivity: phReading.Conductivity,
                    Conductance: phReading.Conductance,
                    Temp: phReading.Temperature,
                    TempCoeff: phReading.Temp_Coefficient,
                    TempRef: phReading.Temp_Reference,
                    K: phReading.K
                })

                Object.assign(objActivity,
                    { strUserId: objUserInfo.UserId },
                    { strUserName: objUserInfo.UserName },
                    { activity: 'Weighment completed by user on TSH ' + strHmi })
                await objActivityLog.ActivityLogEntry(objActivity)


                if (objLastInsertedRepserNo == undefined) {
                    globalData.LastInsertedRepserNo.push({
                        IdsNo: strHmi,
                        LastInsertedRepserNo: lastInsertedID
                    })

                }
                else {
                    objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
                }
                var condtData = globalData.arrConductivityWdata.find(k => k.idsNo == strHmi);
                if (condtData == undefined) {
                    globalData.arrConductivityWdata.push({ idsNo: IdsNo, Conductivity: 0, Conductance: 0, Temp: 0, TempCoeff: 0, TempRef: 0, k: 0 });
                } else {
                    condtData.Conductivity = 0;
                    condtData.Conductance = 0;
                    condtData.Temp = 0;
                    condtData.TempCoeff = 0;
                    condtData.TempRef = 0;
                    condtData.k = 0;
                }
                // console.log(" Report Generated");
                // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);
                //online printing
                if (strPrintingMode == 'Auto') {
                    var Print_Protocol = await objPrint.AutoPrint(strHmi, "Test");

                    if (Print_Protocol == undefined) {
                        Print_Protocol = 'Report Generated';
                        console.log('ProcessPhMeter where print mode is auto')
                    }
                    return Print_Protocol;
                }
                else {
                    return Print_Protocol;
                }
                // return;

            }

        } catch (err) {
            console.log(err);
        }
    }

    async savePH_ISEdata(Data) {
        try {
            var strDP = ''
            var ChannelNo = Data.Parsedata.Channel;
            var strHmi = Data.strHmi;
            var data = Data.Parsedata;
            var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.IdsNo == strHmi)
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode
            var objProduct = globalData.arrMaterialProductSelected.find(k => k.idsNo == strHmi);
            var strUnit = tempCubicInfo[`Sys_Port${ChannelNo}_unit`]
            var strProbeType = tempCubicInfo[`Sys_Port${ChannelNo}_Type`]
            var strProbeID = tempCubicInfo[`Sys_Port${ChannelNo}_ID`]
            var ObjMaterail = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);

            var ARnumber = ObjMaterail.selectedProductDetail.AR_No;
            if (ARnumber == null || ARnumber == "") {
                ARnumber = 'NA';
            }
            var BatchNumer = ObjMaterail.selectedProductDetail.Batch_No;
            if (BatchNumer == null || BatchNumer == "") {
                BatchNumer = 'NA';
            }

            let now = new Date();
            var objActivity = {};
            var objUserInfo = globalData.arrUsers.find(k => k.Hmi == strHmi);
            Object.assign(objActivity,
                { strUserId: objUserInfo.UserId },
                { strUserName: objUserInfo.UserName },
                { activity: 'Weighment started by user on TSH ' + strHmi })
            await objActivityLog.ActivityLogEntry(objActivity)
            var phReading = Data.Parsedata;
            // if (phReading.Concentration.includes('.')) {
            //     var strArrPhVal = phReading.Conductivity.trim().split('.')
            //     strArrPhVal = phReading.Conductivity.trim().split('.')[1].split(' ')
            //     strDP = strArrPhVal[0].length
            // }
            // else {
            strDP = 0
            // }

            var objselectrange = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ProbID: strProbeID
                }
            })
            let strPosTol = objselectrange[0].meterwt_PosTol
            let strNegTol = objselectrange[0].meterwt_NegTol
            if (strProbeType == 'pH/ISE') {
                if (data['Electrode_Type'] != undefined) {
                    var insertData = await models.tbl_weighment_master_ph_ise.create({
                        ProductName: ObjMaterail.selectedProductDetail.Product_Name,
                        ProductType: ObjMaterail.selectedProductDetail.Product_Type,
                        IDSNO: strHmi,
                        MeterID: objselectrange[0].meterwt_ID,
                        NegTol: strNegTol,
                        PosTol: strPosTol,
                        UserID: objUserInfo.UserId,
                        UserName: objUserInfo.UserName,
                        dt: momentObj().format('YYYY-MM-DD'),
                        tm: momentObj().format('HH:mm:ss'),
                        DP: strDP,
                        ArNo: ARnumber,
                        SampleID: BatchNumer,
                        ChannelNo: ChannelNo,
                        PrintNo: 0,
                        ProbID: strProbeID,
                        Slope: phReading.Slope,
                        ProdID: ObjMaterail.selectedProductDetail.Product_ID
                    })
                }
                else {
                    var insertData = await models.tbl_weighment_master_ph.create({
                        ProductName: ObjMaterail.selectedProductDetail.Product_Name,
                        ProductType: ObjMaterail.selectedProductDetail.Product_Type,
                        IDSNo: ObjMaterail.selectedProductDetail.Hmi,
                        MeterID: objselectrange[0].meterwt_ID,
                        NegTol: strNegTol,
                        PosTol: strPosTol,
                        UserID: objUserInfo.UserId,
                        UserName: objUserInfo.UserName,
                        dt: momentObj().format('YYYY-MM-DD'),
                        tm: momentObj().format('HH:mm:ss'),
                        DP: strDP,
                        ArNo: ObjMaterail.selectedProductDetail.AR_No,
                        SampleID: ObjMaterail.selectedProductDetail.Sample_Id,
                        ChannelNo: ChannelNo,
                        PrintNo: 0,
                        ProbID: strProbeID,
                        ProdID: ObjMaterail.selectedProductDetail.Product_ID
                    });
                }

            }
            var resultincomplete = insertData.dataValues.RecNo;
            var lastInsertedID = resultincomplete;

            //*selecting pos and neg tolerences******************* */

            //**************************************************** */

            if (lastInsertedID != 0) {
                if (data['Electrode_Type'] != undefined) {
                    const DetailEntry = await models.tbl_weighment_detail_ph_ise.create({
                        RepSerNo: lastInsertedID,
                        RecSeqNo: 1,
                        ElectrodeType: phReading.Electrode_Type,
                        Concentration: phReading.Concentration,
                        mV: phReading.mV,
                        Temp: phReading.Temperature
                    })
                } else {
                    if (lastInsertedID != 0) {
                        var DetailEntry = await models.tbl_weighment_detail_ph.create({
                            RepSerNo: lastInsertedID,
                            RecSeqNo: 1,
                            PhValue: phReading.pH,
                            MvValue: phReading.mV,
                            Temp: phReading.Temperature
                        })

                    }

                    var ResDetailEntry = DetailEntry.dataValues.RecNo;
                }
            }
            Object.assign(objActivity,
                { strUserId: objUserInfo.UserId },
                { strUserName: objUserInfo.UserName },
                { activity: 'Weighment completed by user on TSH ' + strHmi })
            await objActivityLog.ActivityLogEntry(objActivity)


            if (objLastInsertedRepserNo == undefined) {
                globalData.LastInsertedRepserNo.push({
                    IdsNo: strHmi,
                    LastInsertedRepserNo: lastInsertedID
                })

            }
            else {
                objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
            }

            console.log("Report Generated");
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);
            //online printing
            if (strPrintingMode == 'Auto') {
                var Print_Protocol = await objPrint.AutoPrint(strHmi,"Test");

                if (Print_Protocol == undefined) {
                    Print_Protocol = 'Report Generated';
                    console.log('ProcessPhMeter where print mode is auto')
                }
                return Print_Protocol;
            }
            else {
                return Print_Protocol;
            }
            // return;

            // }


        } catch (err) {
            console.log(err);

        }
    }
}
module.exports = WeighmentSave