const joi = require('joi')
const clsOSPort = require('../model/OS.model')
const OSSChema = require("../validation/OS/OS.schema")
const OSController = new clsOSPort()


exports.getTSHInfo = (req, res) => {

    const {error, value} = OSSChema.getTSHInfo().validate(req.body)
    if(!error){
    OSController.getTSHInfo(req.body)
        .then(result => {
            res.statusCode = 200
            res.send(result)
        }).catch(err => {
            console.log(err)
            res.statusCode = 500
            res.send({
                status: "fail",
                message: "Internal Server Error"
            })
        })
    }else{
        res.statusCode = 400;
        let responseObj= { status: 'Bad Request' , message: error.details[0].message.replace(/\"/g,"") }
        res.send(responseObj);
    }
}

