const Joi = require('joi')
const mqtt = require('mqtt')
const serverDetail = require('../../serverDetail.json')
const globalData = require('../global/globalData')



exports.mqttConnect = (mqtt_ip, mqtt_port = "1883") => {
    try {
        if (globalData.mqttClient.mqtt_Client === undefined){
            const client = mqtt.connect(`tcp://${mqtt_ip}:${mqtt_port}`)
            globalData.mqttClient = { mqtt_Client: client }
            mqttHandler()
        }
    } catch (error) {
        console.log(error)
        throw new Error(error)
    }
}


exports.mqttSendData = async (idsNo, dataToSend) => {
        var client = globalData.mqttClient.mqtt_Client
        if (client != undefined){
        client.publish(idsNo, dataToSend,{ qos: 2 }, () => {
            console.log(idsNo, dataToSend)
        })
    }
}


function mqttHandler() {
    try {
        const mqttClient = globalData.mqttClient.mqtt_Client
        if (globalData.mqttClient.mqtt_Client !== undefined){
            mqttError()
        }
    } catch (error) {
        console.log(error)
        throw new Error(error)
    }
}


function mqttError() {
    setInterval(async () => {
        const mqtt = globalData.mqttClient.mqtt_Client
            if(mqtt.isConnected===false){
                globalData.mqttClient.status="fail"
                globalData.currentPortStatus.forEach(k => {
                    if (k.portDetail.isOpen == true && ( k.type == globalNomenclature.Balance || k.type == globalNomenclature.Vernier || k.type == globalNomenclature.Socoge)){
                        k.portDetail.close(() => {
                            console.log(`port ${k.portNo + 1} closed successfully.`)
                        })
                    }if (!k.mode){
                        client.outgoingStore._inflights.clear()
                        k.isReceived = true
                    }
            })
            }else{
            if(globalData.mqttClient.status==="fail"){
                    globalData.currentPortStatus.forEach(k => {
                    if (( k.type == globalNomenclature.Balance || k.type == globalNomenclature.Vernier || k.type == globalNomenclature.Socoge)){
                    if (k.portDetail.isOpen == false){
                    k.portDetail.open(() => {
                        console.log(`port ${k.portNo + 1} open successfully`)
                    })}
                }
            })
            globalData.mqttClient.status="success"
        }}
        }, 2000)
}

