const Joi = require('joi')
const clsOsOperation = require('../model/os.model')
const OSSchema = require('../validation/OS/OS.schema');

const OSOperation = new clsOsOperation()


exports.getTSHInfo = (req, res) => {
    console.log("request-url => ", req.url)
    console.log("request-body => ", req.body)
    const { error } = OSSchema.getTSHInfo().validate(req.body)

    if (!error) {
    OSOperation.getTSHInfo(req.body)
        .then(result => {
            console.log("response-body => ", result)
            res.statusCode = 200
            res.send(result)
        })
        .catch(err => {
            console.log(err)
            var obj = {
                status: "fail",
                message: "Internal Server Error"
            }
            console.log("response-body => ", obj)
            res.statusCode = 500
            res.send(obj)
        })
    }else{
        res.statusCode = 400
        var obj = {
            status: "fail",
            message: error.details[0].message.replace(/"/g, '')
        }
        console.log("response-body => ", obj)
        res.send(obj)
    }
}



