const joi = require('joi')
const clsSerialPort = require('../model/serialport.model')
const serialportSchema = require('../validation/serialport/serialport.schema');

const serialport = new clsSerialPort()


exports.openPort = (req, res) => {
    console.log("request-url => ", req.url)
    console.log("request-body => ", req.body)
    const { error } = serialportSchema.openPort().validate(req.body)
    if (!error) {
        serialport.openPort(req.body)
        .then(result => {
            console.log("response-body => ", result)
            res.statusCode = 200
            res.send(result)
        }).catch(err => {
            console.log(err)
            var obj = {
                status: "fail",
                message: "Internal Server Error"
            }
            console.log("response-body => ", obj)
            res.statusCode = 500
            res.send(obj)
        })
    }
    else {
        res.statusCode = 400
        var obj = {
            status: "fail",
            message: error.details[0].message.replace(/"/g, '')
        }
        console.log("response-body => ", obj)
        res.send(obj)
    }
}

exports.closePort = (req, res) => {
    console.log("request-url => ", req.url)
    console.log("request-body => ", req.body)
    const { error } = serialportSchema.closePort().validate(req.body)
    if (!error) {
        serialport.closePort(req.body)
        .then(result => {
            console.log("response-body => ", result)
            res.statusCode = 200
            res.send(result)
        })
        .catch(err => {
                console.log(err)
                var obj = {
                    status: "fail",
                    message: "Internal Server Error"
                }
                console.log("response-body => ", obj)
                res.statusCode = 500
                res.send(obj)
            })
    }
    else {
        res.statusCode = 400
        var obj = {
            status: "fail",
            message: error.details[0].message.replace(/"/g, '')
        }
        console.log("response-body => ", obj)
        res.send(obj)
    }
}

exports.dataReceived = (req, res) => {
    console.log("request-url => ", req.url)
    console.log("request-body => ", req.body)
    const { error } = serialportSchema.dataReceived().validate(req.body)
    if (!error) {
        serialport.dataReceived(req.body)
        .then(result => {
            console.log("response-body => ", result)
            res.statusCode = 200
            res.send(result)
        })
        .catch(err => {
                console.log(err)
                var obj = {
                    status: "fail",
                    message: "Internal Server Error"
                }
                console.log("response-body => ", obj)
                res.statusCode = 500
                res.send(obj)
            })
    }else {
        res.statusCode = 400
        var obj = {
            status: "fail",
            message: error.details[0].message.replace(/"/g, '')
        }
        console.log("response-body => ", obj)
        res.send(obj)
    }
}

