const { mqttSendData } = require('../Mqtt/mqtt.model')
const globalNomenclature = require('../global/globalNomenclature')
const globalData = require('../global/globalData')

exports.autoBalanceData = async (data, selectedPort, port) => {
    var arrConfigSetting = globalData.configSetting.find( k => k.portNo == selectedPort)
    if (arrConfigSetting !== undefined){
    var configSetting = arrConfigSetting.configSetting
    var dataArr = data.split(" ").filter(k => k.length !== 0)
    if(dataArr.length!==0){
    var data_weight;
    for(let k in dataArr){
        let sample = dataArr[k]
        if(isNaN(Number(sample))){
            if((Number(k)+1) === Number(dataArr.length)) return console.log("invalid weight", sample)
            continue;
        }else{
            data_weight=sample
            break;
        }
    }
    var tareCommand = configSetting.Tare_Command
    var arrCount = globalData.arrCount.find(k => k.portNo == selectedPort)
    var serialPort = globalData.currentPortStatus.find(k => k.portNo == selectedPort)
    if (arrCount !== undefined && serialPort !== undefined && serialPort.isReceived !== false){
    console.log(data)
    if(arrCount.balanceStarted == false) arrCount.balanceStarted = true      
    var weight = Number(data_weight.split(" ")[0])
    if (isNaN(weight)) return console.log("invalid pattern or weight", weight)
    if (weight < 0 || data.includes("-")) {
        // if (arrCount.weight != 0)  
        arrCount.tareCommandCount = 0
        arrCount.tareCommandCountComplete = false
        arrCount.weight = 0
        arrCount.count = 0
        port.write(tareCommand)
        console.log('negative value', data)
        return;
    }
    if (arrCount.tareCommandCountComplete === false) {
        if (0 <= weight && weight <= 0.01 && arrCount.tareCommandCount <= 2) {
            if (arrCount.tareCommandCount + 1 == 2) return arrCount.tareCommandCountComplete = true
            return arrCount.tareCommandCount++
        }
        else {
            arrCount.tareCommandCount = 0
            arrCount.tareCommandCountComplete = false
            arrCount.weight = 0
            arrCount.count = 0
            port.write(configSetting.Tare_Command)
            return console.log('Invalid Weight sending tareCommand', data)
        }
    } else {
        // if (weight <= 0.01) {
        //     if (arrCount.weight == 0) return;
        //     else {
        //         arrCount.tareCommandCount = 0
        //         arrCount.tareCommandCountComplete = false
        //         arrCount.weight = 0
        //         arrCount.count = 0
        //         port.write(tareCommand)
        //         return console.log('weight changes drastically', data)
        //     }
        // }
        // else if (0.01 < weight && weight <= Number(configSetting.Min_Threshold)) {
        //     arrCount.tareCommandCount = 0
        //     arrCount.tareCommandCountComplete = false 
        //     arrCount.weight = 0
        //     arrCount.count = 0
        //     port.write(tareCommand)
        //     return console.log('tareCommand sent Invalid weight between 10 mg and Min_Threshold', data)
        // }
        if (weight <= Number(configSetting.Min_Threshold)){
            if(arrCount.weight === 0){
                return;
            }
        }
        if (arrCount.weight == 0) {
            return arrCount.weight = weight;
        } 
        else if (weight == arrCount.weight) {
            arrCount.count++
        } 
        else{
            arrCount.weight = 0
            arrCount.count = 0
            return;
        }
        if (arrCount.count + 1 == configSetting.Stability_Threshold) {
            console.log("Weight Sent => ", data, "count =>", arrCount.count + 1 )
            arrCount.tareCommandCount = 0
            arrCount.tareCommandCountComplete = false
            arrCount.weight = 0
            arrCount.count = 0
            // port.write(tareCommand)
            mqttSendData(`${arrCount.idsNo}_out`, `ComRead:${arrCount.portNo + 1}:${data}`)
            serialPort.portDetail.close(() => {
                console.log(`port ${selectedPort + 1} closed Successfully`)
            })
            return serialPort.isReceived = false  
        }}
        }
    }
}
}