const { mqttConnect } = require('../Mqtt/mqtt.model')
const { networkInterfaces } = require('os')
const serverDetail =require("../../serverDetail.json")
const { execSync } = require('child_process')

class OSOperation {

    async getTSHInfo(value) {
        try {
            var mqtt_ip = value.mqtt_ip
            var mqtt_port = value.mqtt_port
            mqttConnect(mqtt_ip, mqtt_port)
            var tsh_ip, macAddress
            networkInterfaces().eth0.forEach(k => {
                if (k.family == "IPv4" && k.address != "127.0.0.1" && !k.internal){
                    tsh_ip = k.address
                    macAddress = k.mac
                    return
                }
            })
            var serialNumber = execSync("cat /sys/firmware/devicetree/base/serial-number",{encoding:"utf8"}).slice(0,-1)
            console.log("TSH IP is => ", tsh_ip, "and Serial Number is => ", serialNumber)
            return {
                status: "success",
                result: {
                    serialNumber,
                    tsh_ip,
                    macAddress
                }
            }
        } catch (err) {
            throw new Error(err)
        }
    }

    
}

module.exports = OSOperation