const { SerialPort } = require('serialport');
const { ReadlineParser } = require('@serialport/parser-readline')
const { autoDetect } = require('@serialport/bindings-cpp')
const getSerialPortPath = require('./serialport.path')
const globalNomenclature = require('../global/globalNomenclature')
const { vernierInstrumentData } = require('../instrumentData/vernier.data')
const { bulkInstrumentData } = require('../instrumentData/bulkInstrument.data')
const globalData = require('../global/globalData')
const { mqttSendData } = require('../Mqtt/mqtt.model');
const { autoBalanceData } = require('../instrumentData/autoBalance.data');


class SerialPortIO {


async openPort(value) {
        try {
            var idsNo = value.idsNo
            var instrumentSettings = value.configSetting
            var mqttClient = globalData.mqttClient.mqtt_Client
            if (mqttClient === undefined || mqttClient.connected === false) return { status: "fail", message: "Unable to connect Broker Ip"}
                var configSetting = instrumentSettings[0]
                var instrumentType = configSetting.type
                let selectedPort = configSetting.portNo - 1
                var baudRate = configSetting.Baud_Rate
                var dataBits = configSetting.Data_Bit
                var parity = configSetting.Parity.toLowerCase()
                // configSetting.Min_Threshold = configSetting.Min_Threshold < 0.01 ? 0.01 : configSetting.Min_Threshold
                var arrCurrentPortStatus = globalData.currentPortStatus.find(k => k.portNo == selectedPort)
                var arrConfigSetting = globalData.configSetting.find(k => k.portNo == selectedPort)
                var arrCount = globalData.arrCount.find(k => k.portNo == selectedPort)
                var arrPort = await getSerialPortPath()
                if (arrPort.status === "fail"){
                    return { status: 'fail', message: "Port Not Found" }
                }else{
                    arrPort=arrPort.port
                }
                var symbol = (instrumentType == globalNomenclature.Vernier || instrumentType == globalNomenclature.Socoge) ? "\r" : '\n'
                var mode = false;
                if (instrumentType === globalNomenclature.Balance && configSetting.Auto_Tare === true) {
                    if (arrCount == undefined) {
                        globalData.arrCount.push({
                            portNo: selectedPort,
                            count: 0,
                            weight: 0,
                            tareCommandCountComplete: false,
                            tareCommandCount: 0,
                            idsNo: idsNo,
                            balanceStarted: false
                        })
                    } else {
                        arrCount.count = 0
                        arrCount.weight = 0
                        arrCount.tareCommandCountComplete = false
                        arrCount.idsNo = idsNo
                        arrCount.tareCommandCount = 0
                        arrCount.balanceStarted = false
                    }
                    mode = true
                } 
                else if (instrumentType != globalNomenclature.Balance && instrumentType != globalNomenclature.Vernier && instrumentType != globalNomenclature.Socoge) {
                    var gblBulkData = globalData.bulkData.find(k => k.portNo == selectedPort)
                    if (gblBulkData == undefined) {
                        globalData.bulkData.push({
                            portNo: selectedPort,
                            bulkData: '',
                            idsNo: idsNo,
                            dataInitialize: false,
                            Data_Count: 0,
                            Data_Flag: false,
                            Data_String: '',
                            Data_Timeout: null
                        })
                    } else {
                        gblBulkData.bulkData = '',
                        gblBulkData.idsNo = idsNo
                        gblBulkData.dataInitialize = false
                        gblBulkData.Data_Count = 0
                        gblBulkData.Data_Flag = false
                        gblBulkData.Data_String = ''
                        gblBulkData.Data_Timeout = null
                    }
                    mode = true
                }
                if (arrConfigSetting == undefined) {
                    globalData.configSetting.push({
                        portNo: selectedPort,
                        configSetting: configSetting
                    })
                } else {
                    arrConfigSetting.configSetting = configSetting
                }
                if (arrCurrentPortStatus != undefined) {
                    var serialport = arrCurrentPortStatus.portDetail
                    if (serialport.isOpen) {serialport.close()}
                    globalData.currentPortStatus.splice(globalData.currentPortStatus.findIndex(k => k.portNo == selectedPort), 1)
                }
                var Path = arrPort[selectedPort]
                var port = new SerialPort({path: Path, baudRate: baudRate,dataBits: dataBits,parity: parity,autoOpen: false})
                .setDefaultEncoding('utf-8')
                .setEncoding('utf-8')
                port.open(() => console.log("port open successfully."))
                var serialPort=port.pipe(new ReadlineParser({ delimiter: symbol }))
                serialPort.on('data', (data) => {
                    if (instrumentType == globalNomenclature.Balance && configSetting.Auto_Tare === true){
                        autoBalanceData(data,selectedPort,port)
                    }else if (instrumentType == globalNomenclature.Balance || instrumentType == globalNomenclature.Vernier || instrumentType == globalNomenclature.Socoge){
                        vernierInstrumentData(data,selectedPort, idsNo)
                    }else{
                        bulkInstrumentData(data,selectedPort,idsNo)
                    }
                })
                globalData.currentPortStatus.push({
                    portNo: selectedPort,
                    portDetail: port,
                    type: instrumentType,
                    isReceived: true,
                    mode,
                    idsNo
                })
        return {
            status: 'success',
            message: `Port Open Successfully`
        }

    } catch(err) {
        throw new Error(err)
    }
}

async closePort(value) {
    try {
        var configSetting = value.configSetting
        var selectedPort = Number(value.portNo) - 1
        var port = globalData.currentPortStatus.find(k => k.portNo == selectedPort)
        if (port != undefined){         
        port = port.portDetail
        if (port.isOpen == true){
        port.close(() => {
            console.log(`Port ${value.portNo} closed successfully`)
            })
        }
        }              
    globalData.currentPortStatus.find(k => k.portNo == selectedPort) != undefined ? globalData.currentPortStatus.splice(globalData.currentPortStatus.findIndex(k => k.portNo == selectedPort), 1) : globalData.currentPortStatus
    globalData.arrCount.find(k => k.portNo == selectedPort) != undefined ? globalData.arrCount.splice(globalData.arrCount.findIndex(k => k.portNo == selectedPort), 1) : globalData.arrCount
    globalData.bulkData.find(k => k.portNo == selectedPort) != undefined ? globalData.bulkData.splice(globalData.bulkData.findIndex(k => k.portNo == selectedPort), 1) : globalData.bulkData
    globalData.configSetting.find(k => k.portNo == selectedPort) != undefined ? globalData.configSetting.splice(globalData.configSetting.findIndex(k => k.portNo == selectedPort), 1) : globalData.configSetting

    return {status: 'success',message: `Port closed successfully`}

    } catch (err) {
        throw new Error(err)
    }
}

async dataReceived(value) {
    try {
        var portNo = value.portNo - 1
        var currentPortStatus = globalData.currentPortStatus.find(k => k.portNo == portNo)
        var arrCount = globalData.arrCount.find(k => k.portNo == portNo)
        var arrConfigSetting = globalData.configSetting.find(k => k.portNo == portNo)
        var arrBulkData = globalData.bulkData.find(k => k.portNo == portNo)
        if (currentPortStatus == undefined) return { status: 'success', message: 'port is already closed.' }
        if (currentPortStatus.isReceived == true) return { status: 'success', message: 'Already resumed port' }
        var instrumentType = currentPortStatus.type
        var serialPort = currentPortStatus.portDetail
        if (instrumentType == globalNomenclature.Balance && arrCount != undefined) {
            arrCount.tareCommandCount = 0
            arrCount.tareCommandCountComplete = false
            arrCount.weight = 0
            arrCount.count = 0
            if (serialPort.isOpen == false) 
                serialPort.open(err => {
                if (err)
                    throw new Error('unable to open port')
                console.log(`port ${value.portNo} open Successfully`)
            })
            serialPort.write(arrConfigSetting.configSetting.Tare_Command)
        }
        else if(arrBulkData != undefined){
            if(arrBulkData.bulkData.length != 0 && globalData.mqttClient.mqtt_Client.outgoingStore._inflights.size == 0){
                if (arrBulkData.Data_Flag == true)
                    arrBulkData.bulkData = arrBulkData.bulkData.slice(0, arrBulkData.bulkData.lastIndexOf("ComRead")) + "::StoredData"
                mqttSendData(`${arrBulkData.idsNo}_out`, `ComRead:${value.portNo}:${arrBulkData.bulkData}`)
                arrBulkData.bulkData = ""
                arrBulkData.Data_Flag = false
                return {status: "success", message: "Bulk Data Sent" }
            }
            if(globalData.mqttClient.mqtt_Client.outgoingStore._inflights.size != 0)
                return { status: "success", message: "Bulk Data in queue" }
        }
        currentPortStatus.isReceived = true
        return { status: 'success', message: "Port Resumed" }
    } catch (error) {
        throw new Error(error)
    }
}

}


module.exports = SerialPortIO
